import java.io.*;
import java.util.Arrays;


public class Decrypt {
	/** Arguments: the number of consecutive characters to use when calculating the character frequencies **/ 
	public static void main(String[] args) {
		String trainer   = new String();
		String encrypted = new String();
		int consec       = 1;
		
		if (args.length != 0)
			consec = Integer.valueOf(args[0]);
		
		// can't handle more than 3 chars for memory reasons
		if ( consec > 3) {
			System.out.println("Cannot use that many characters. 3 is the maximum.");
			return;
		}
		
		
		try {
			// read in texts
			trainer = readIn("sample.txt");
			encrypted = readIn("hidden.txt");
		}
		catch (IOException e){
			System.out.println("Error reading in files:\n" + e);
		}
		
		// get frequencies
		int[] tFreqs = calcFreqs(trainer, consec);
		int[] eFreqs = calcFreqs(encrypted, consec);
		
		// decrypt the file
		decr(tFreqs, eFreqs, encrypted, "decrypted.txt", consec);

	}
	
	/** Read a file into a String. Newlines are removed. **/
	private static String readIn(String file) throws IOException {
		String text           = new String();
		String line           = new String();
		FileReader reader     = null;
		BufferedReader buffer = null;
		
		try {
			// setup IO buffers
			reader = new FileReader(file);
			buffer = new BufferedReader(reader);
			
			// read in file
			while ( (line = buffer.readLine()) != null ) {
				text += line;
			}
			
		}
		catch (FileNotFoundException e) {
			System.out.println("Error reading in files:\n" + e);
		}
		finally {
            // close reader
			reader.close();
			buffer.close();
		}
		
		return text;
	}
	
	/** Calculates the frequency of each character in the input String and returns
	 *  an int array
	 **/
	private static int[] calcFreqs(String text, int consecs) {
		int chars[]  = new int[(int) Math.pow(128,consecs)];
		int stringLen = text.length();
		char[] prev = text.substring(0,consecs-1).toCharArray(); // turn first consecs chars into a char array
		
		// create array of the number of times each character appears by casting char to ascii value
		for (int i=consecs-1; i<stringLen; ++i) {
			char let = text.charAt(i);
			int val = 0;

			for(int j = 0; j < consecs - 1; ++j) {
				val += prev[j] * Math.pow(128,consecs-j-1); // each char is a power of 128, i.e. "at" = 97 + 116*128 = 14945
				if ( j > 0 )
					prev[j-1] = prev[j]; // update prev array
			}
			val += let;
			if (consecs > 1) prev[consecs-2] = let;
			++chars[val]; // let is cast to int ascii value 0-127
		}

		return chars;
	}
	
	/** Decrypts the file and writes it to a file **/
	private static void decr(int[] base, int[] encrypted, String text, String file, int consec) {
		int[] bSorted = sortChar(base);
		int[] eSorted = sortChar(encrypted);
		int[] used    = new int[text.length()];
		int skip;
		String dtext  = text;
		
		for (int i = bSorted.length-1; i>=0; --i) {

			if (bSorted[i] == 0) break;
			
			// convert number back to string
			String sub = intToString(eSorted[i]);
			
			// replace characters
			for (int j = 0; j<=text.length()-consec; ++j) {
				skip = 0;
				// check if the characters have already been replaced
				for (int k = j; k < j+consec; ++k) {
					if (used[k] == 1) skip = 1;
				}
				if ( skip == 0 && text.substring(j, j+consec).equals(sub)) {
					dtext = dtext.substring(0, j) + intToString(bSorted[i]) + dtext.substring(j+consec, dtext.length());
					// mark these characters as changed
					for (int l = j; l < j+consec; ++l) {
						used[l] = 1;
					}
				}
			}
		}
		// write results to answer file
		try {
			writeOut(dtext, file);
		}
		catch (IOException e) {
			System.out.println("Error writing to file:\n" + e);
		}
		
		
	}
	
	/** takes in an int[] A and returns an int[] B of the original indeces of A sorted **/
	private static int[] sortChar(int[] unsorted) {
		int len      = unsorted.length;
		int[] sorted = new int[len];
		int[] temp   = unsorted.clone();
		
		// sort unsorted
		Arrays.sort(unsorted);
		
		// attempt to match values in sorted list to unsorted list
		for (int i = len-1; i>=0; --i) {
			if (unsorted[i] == 0) break;
			
			for (int j = 0; j<len; ++j) {
				if (temp[j] == unsorted[i]) {
					sorted[i] = j;
					temp[j] = 0;
					break;
				}
			}
		}
		
		return sorted;
		
	}
	
	/** writes the given text to the given file **/
	private static void writeOut(String text, String file) throws IOException {
		FileOutputStream output = null;
		PrintWriter writer      = null;
		try {
			output = new FileOutputStream(file);
			writer  = new PrintWriter(output, true);
			
			writer.println(text);
		}
		finally {
			writer.close();
			output.close();
		}
	}
	
	/** converts an int to a string based on powers of 128 **/
	private static String intToString(int val) {
		String result = new String();
		
		// calculate the number of characters
		int n = 1;
		while (Math.pow(128,n) < val) ++n;
		
		// remove characters by repeatedly reducing powers of 128
		for ( int i = 0; i<n; ++i) {
			int el = val % 128;
			result = (char) el + result;
			val = (val - el) / 128;
		}
		
		return result;

	}

}
